<?php
// account_tasks.php - Mode A pre-signup helper
session_start();
require __DIR__ . '/db_tool.php';
if (empty($_SESSION['user'])) {
  header('Location: user_login.php'); exit;
}
$user = $_SESSION['user'];
$msg = '';

// handle add task
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['action']) && $_POST['action']==='add') {
  $email = trim($_POST['email']??'');
  $pwd = trim($_POST['password']??'');
  $fn = trim($_POST['first_name']??'');
  $ln = trim($_POST['last_name']??'');
  $dob = $_POST['birth_date']??null;
  $gender = $_POST['gender']??null;
  $notes = $_POST['notes']??null;
  if ($email=='' || $pwd=='') {
    $msg = 'Email & Password wajib diisi';
  } else {
    $stmt=$conn->prepare("INSERT INTO account_tasks (user_id,suggested_email,suggested_password,first_name,last_name,birth_date,gender,notes) VALUES (?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isssssss',$user['id'],$email,$pwd,$fn,$ln,$dob,$gender,$notes);
    if ($stmt->execute()) $msg='Task ditambahkan.'; else $msg='Gagal menambah task';
  }
}

// handle mark done
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['action']) && $_POST['action']==='done') {
  $id=intval($_POST['id']);
  $final_email=trim($_POST['final_email']??'');
  $final_pass=$_POST['final_password']??'';
  $stmt=$conn->prepare("SELECT * FROM account_tasks WHERE id=? AND user_id=? AND status='pending'");
  $stmt->bind_param('ii',$id,$user['id']); $stmt->execute(); $r=$stmt->get_result();
  if ($r->num_rows===0) { $msg='Task tidak ditemukan'; }
  else {
    $enc = encrypt_password($final_pass,$ENCRYPTION_KEY);
    $u=$conn->prepare("UPDATE account_tasks SET status='done',completed_at=NOW(),final_email=?,encrypted_password=? WHERE id=?");
    $u->bind_param('ssi',$final_email,$enc,$id); $u->execute();
    // create job row
    $job_name="Signup ".$final_email;
    $ins=$conn->prepare("INSERT INTO jobs (user_id,job_name,email,encrypted_password,status,created_at) VALUES (?,?,?,?, 'pending', NOW())");
    $ins->bind_param('isss',$user['id'],$job_name,$final_email,$enc);
    $ins->execute();
    $msg='Task selesai & job dibuat.';
  }
}

// fetch tasks
$stmt=$conn->prepare("SELECT * FROM account_tasks WHERE user_id=? ORDER BY created_at DESC");
$stmt->bind_param('i',$user['id']); $stmt->execute(); $tasks=$stmt->get_result();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Account Tasks - Mode A</title>
<style>textarea{width:100%;height:60px;}</style>
</head><body>
<h2>IVIEM KEY GENERATOR — Account Tasks (Mode A)</h2>
<?php if($msg) echo "<p style='color:green;'>".htmlspecialchars($msg)."</p>"; ?>

<h3>Tambah Task Baru</h3>
<form method="post">
<input type="hidden" name="action" value="add">
Email (Relay alias): <input name="email" required><br>
Password: <input name="password" required><br>
First Name: <input name="first_name"><br>
Last Name: <input name="last_name"><br>
Birth Date: <input type="date" name="birth_date"><br>
Gender: <input name="gender"><br>
Notes:<br><textarea name="notes"></textarea><br>
<button type="submit">Tambah Task</button>
</form>

<h3>Daftar Task</h3>
<table border=1 cellpadding=5>
<tr><th>ID</th><th>Email</th><th>Pass</th><th>Nama</th><th>Status</th><th>Aksi</th></tr>
<?php while($t=$tasks->fetch_assoc()): ?>
<tr>
<td><?= $t['id'] ?></td>
<td><?= htmlspecialchars($t['suggested_email']) ?></td>
<td><?= htmlspecialchars($t['suggested_password']) ?></td>
<td><?= htmlspecialchars(($t['first_name']??'').' '.($t['last_name']??'')) ?></td>
<td><?= $t['status'] ?></td>
<td>
<?php if($t['status']==='pending'): ?>
<form method="post" style="margin-bottom:5px;">
<input type="hidden" name="action" value="done">
<input type="hidden" name="id" value="<?= $t['id'] ?>">
Final Email: <input name="final_email" value="<?= htmlspecialchars($t['suggested_email']) ?>"><br>
Final Pass: <input type="password" name="final_password" value="<?= htmlspecialchars($t['suggested_password']) ?>"><br>
<button type="submit">Mark Done</button>
</form>
<a href="https://accounts.google.com/signup" target="_blank">Open Signup</a> |
<button onclick="navigator.clipboard.writeText('<?= htmlspecialchars($t['suggested_email']) ?> <?= htmlspecialchars($t['suggested_password']) ?>')">Copy Data</button>
<?php else: ?>
Done at <?= $t['completed_at'] ?><br>Final Email: <?= htmlspecialchars($t['final_email']) ?>
<?php endif; ?>
</td>
</tr>
<?php endwhile; ?>
</table>

<p><a href="user_dashboard.php">← Back to Dashboard</a></p>
</body></html>
