<?php
// db_tool.php - common DB connect + helper functions
$cfg = require __DIR__ . '/tool_config.php';
$db = $cfg['db'];
$WORKER_TOKEN = $cfg['worker_token'];
$ENCRYPTION_KEY = $cfg['encryption_key']; // base64 encoded 32 bytes key

$conn = new mysqli($db['host'], $db['user'], $db['pass'], $db['name']);
if ($conn->connect_error) {
  http_response_code(500);
  die(json_encode(['error' => 'DB connection failed']));
}
// set charset
$conn->set_charset('utf8mb4');

function encrypt_password($plaintext, $key_base64) {
  $key = base64_decode($key_base64);
  $iv = openssl_random_pseudo_bytes(16);
  $cipher = openssl_encrypt($plaintext, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
  return base64_encode($iv . $cipher);
}
function decrypt_password($blob_base64, $key_base64) {
  if (!$blob_base64) return null;
  $key = base64_decode($key_base64);
  $data = base64_decode($blob_base64);
  if (strlen($data) < 16) return null;
  $iv = substr($data, 0, 16);
  $cipher = substr($data, 16);
  $plain = openssl_decrypt($cipher, 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $iv);
  return $plain;
}
?>