<?php
// new_job.php - returns one pending job for worker (requires X-Worker-Token)
header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/db_tool.php';

// check worker token header
$headers = getallheaders();
$provided = $headers['X-Worker-Token'] ?? $headers['x-worker-token'] ?? null;
if (!$provided || $provided !== $WORKER_TOKEN) {
  http_response_code(403);
  echo json_encode(['error' => 'Invalid worker token']);
  exit;
}

// begin transaction to lock job row
$conn->begin_transaction();
// adjust column names according to your jobs table: email, encrypted_password, status
$sql = "SELECT id, user_id, job_name, email, encrypted_password FROM jobs WHERE status='pending' ORDER BY id ASC LIMIT 1 FOR UPDATE";
$res = $conn->query($sql);
if (!$res) {
  $conn->rollback();
  http_response_code(500);
  echo json_encode(['error' => 'DB query failed']);
  exit;
}
if ($res->num_rows === 0) {
  $conn->commit();
  echo json_encode(['id' => null]);
  exit;
}
$row = $res->fetch_assoc();
$job_id = (int)$row['id'];

// mark processing so other workers won't take it
$update = $conn->prepare("UPDATE jobs SET status='processing', updated_at = NOW() WHERE id = ?");
$update->bind_param('i', $job_id);
$update->execute();
$conn->commit();

// decrypt password for worker
$plain_password = decrypt_password($row['encrypted_password'], $ENCRYPTION_KEY);

// return job JSON (avoid sensitive debug logging)
echo json_encode([
  'id' => $job_id,
  'user_id' => $row['user_id'],
  'job_name' => $row['job_name'],
  'email' => $row['email'],
  'password' => $plain_password
], JSON_UNESCAPED_SLASHES);
exit;
?>