<?php
// submit_key.php - worker posts {job_id, api_key} JSON to store result
header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/db_tool.php';

// check worker token header
$headers = getallheaders();
$provided = $headers['X-Worker-Token'] ?? $headers['x-worker-token'] ?? null;
if (!$provided || $provided !== $WORKER_TOKEN) {
  http_response_code(403);
  echo json_encode(['error' => 'Invalid worker token']);
  exit;
}

$body = json_decode(file_get_contents('php://input'), true);
if (empty($body['job_id']) || empty($body['api_key'])) {
  http_response_code(400);
  echo json_encode(['error' => 'job_id and api_key required']);
  exit;
}
$job_id = (int)$body['job_id'];
$api_key = $conn->real_escape_string($body['api_key']);

$stmt = $conn->prepare("UPDATE jobs SET api_key = ?, status = 'done', updated_at = NOW() WHERE id = ?");
$stmt->bind_param('si', $api_key, $job_id);
if ($stmt->execute()) {
  echo json_encode(['ok' => true]);
} else {
  http_response_code(500);
  echo json_encode(['error' => 'DB update failed']);
}
exit;
?>